﻿using System;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.AdvancedAPI.Sample2
{
    public partial class FormMain : Form
    {
        public enum HookType : int
        {
            WH_JournalRecord = 0x0,
            WH_JournalPlayback = 0x1,
            WH_Keyboard = 0x2,
            WH_GetMessage = 0x3,
            WH_CallWndProc = 0x4,
            WH_CBT = 0x5,
            WH_SysMsgFilter = 0x6,
            WH_Mouse = 0x7,
            WH_Hardware = 0x8,
            WH_Debug = 0x9,
            WH_Shell = 0xA,
            WH_ForEGroundIDLE = 0xB,
            WH_CallWndProcert = 0xC,
            WH_KeyboardLL = 0xD,
            WH_MouseLL = 0xE
        }

        public delegate IntPtr HookProc(int code, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll")]
        public static extern IntPtr SetWindowsHookEx(HookType hookType, HookProc lpFunction, IntPtr hMod, uint dwThreadId);

        [DllImport("user32.dll")]
        public static extern bool UnhookWindowsHookEx(IntPtr hookHandle);

        [DllImport("user32.dll")]
        public static extern IntPtr CallNextHookEx(IntPtr hookHandle, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetModuleHandle(string lpModuleName);

        private const int WM_KeyDown = 0x0100;
        private static readonly HookProc _proc = HookCallback;
        private static IntPtr _hookID = IntPtr.Zero;

        public static string TextResult { get; set; }

        private static IntPtr SetHook(HookProc proc)
        {
            using (Process curProcess = Process.GetCurrentProcess())
            using (ProcessModule curModule = curProcess.MainModule)
            {
                IntPtr myModuleHandle = GetModuleHandle(curModule.ModuleName);
                return SetWindowsHookEx(HookType.WH_KeyboardLL, proc, myModuleHandle, 0);
            }
        }

        private static IntPtr HookCallback(int nCode, IntPtr wParam, IntPtr lParam)
        {
            if (nCode >= 0 && wParam == (IntPtr)WM_KeyDown)
            {
                int vkCode = Marshal.ReadInt32(lParam);
                TextResult = ((Keys)vkCode).ToString();
            }
            return CallNextHookEx(_hookID, nCode, wParam, lParam);
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonInstallHookClick(object sender, EventArgs e)
        {
            _hookID = SetHook(_proc);
            buttonUninstallHook.Enabled = true;
            buttonInstallHook.Enabled = false;
            timerGetString.Start();
        }

        private void ButtonUninstallHookClick(object sender, EventArgs e)
        {
            UnhookWindowsHookEx(_hookID);
            buttonUninstallHook.Enabled = false;
            buttonInstallHook.Enabled = true;
            timerGetString.Stop();
        }

        private void TimerGetStringTick(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(TextResult)) return;
            textBoxResult.Text += TextResult;
            TextResult = String.Empty;
        }
    }
}